VERSION 5.00
Begin VB.Form fDemo 
   BackColor       =   &H00808080&
   Caption         =   "ChipMunk-Physics"
   ClientHeight    =   9915
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   12825
   LinkTopic       =   "Form1"
   ScaleHeight     =   661
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   855
   StartUpPosition =   3  'Windows-Standard
   Begin VB.PictureBox picTopBar 
      Align           =   1  'Oben ausrichten
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   0  'Kein
      Height          =   915
      Left            =   0
      ScaleHeight     =   915
      ScaleWidth      =   12825
      TabIndex        =   1
      Top             =   0
      Width           =   12825
      Begin VB.CheckBox chkStretch 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Stretch the 800x600 Surface to current Form-ClientArea"
         Height          =   285
         Left            =   1680
         TabIndex        =   4
         Top             =   60
         Width           =   4515
      End
      Begin VB.CheckBox chkDirectXMode 
         BackColor       =   &H00FFFFFF&
         Caption         =   "DirectX-Mode (Upload as Texture)"
         Height          =   285
         Left            =   6360
         TabIndex        =   3
         Top             =   60
         Width           =   3015
      End
      Begin VB.CheckBox chkVisualize 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Visualize"
         Height          =   285
         Left            =   240
         TabIndex        =   2
         Top             =   60
         Value           =   1  'Aktiviert
         Width           =   1155
      End
      Begin VB.Label Label1 
         BackColor       =   &H00FFFFFF&
         Caption         =   $"fDemo.frx":0000
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00C00000&
         Height          =   435
         Left            =   240
         TabIndex        =   5
         Top             =   420
         Width           =   12255
      End
   End
   Begin ChipmunkCairo.ucPhysicsCanvas ucPhysicsCanvas1 
      Height          =   3525
      Left            =   180
      TabIndex        =   0
      Top             =   1110
      Width           =   6405
      _ExtentX        =   11298
      _ExtentY        =   6218
   End
End
Attribute VB_Name = "fDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private WithEvents PhEngine As cPhysicsEngine
Attribute PhEngine.VB_VarHelpID = -1

Private OuterBorders As cOuterBorders
Private Ramp As cRamp
Private Ball As cBall
Private Fluid As cFluid

'the other chipmunk-shapes are hosted in dedicated classes,
'the simple Demo-Mouseshape below does not need "special treatment" yet...
'(not that much "Mouse-related code" here within the form)
Private MouseShape As cpBoxShape

Private Sub Form_Load()
  ScaleMode = vbPixels 'set the forms scalemode to Pixels
  
  'since we need the PhysicsEngine throwing Events here in this Main-Form,
  'we place a Reference from the globally available PhEngine locally in our
  '"WithEvents-Variable", defined on top of this Code-Module
  Set PhEngine = modGlobal.PhEngine

  'define the size of our rendering-area ... and this time we do *not* change the Usercontrol-internal
  'Cairo-Surface-Dimensions dynamically in the Resize-Event of the Control - so we do this once, only here
  chkDirectXMode.Enabled = ucPhysicsCanvas1.InitSurface(800, 600, False) '<- in this "Stress-Demo" we do not wait for the VBlanc, to achieve higher FPS
  If chkDirectXMode.Enabled Then chkDirectXMode.Value = 1 'reflect, that DX-Mode is available and successfully initialized
  
  'now the construction of our 4 chipmunk-Encapsulation-Objects (please look into the appropriate .Construct-routines of these Classes)
  Set OuterBorders = New cOuterBorders
  OuterBorders.Construct 10, 10, 800 - 20, 600 - 20, 10
  
  Set Ramp = New cRamp
  Ramp.Construct 30, 500, 500, 270
  
  Set Ball = New cBall
  Ball.Construct 400, 200, 20, 14
  
  Set Fluid = New cFluid
  Fluid.Construct
  
  'finally some initial settings for the Simulation
  PhEngine.Space.Gravity_SetXY 0, -105
  PhEngine.Space.Damping = 2.05
  PhEngine.Space.Iterations = 2.05
  PhEngine.Space.ElasticIterations = 0

  'Ok, let's start the physics-calulations now (resulting in the continuously incoming Events below) ...
  'other than in the "Simple-Balls-Demo", we tell the engine per last param, to calculate each
  'step with a fixed rate ... this mode is recommended when we expect FPS below 60-80
  PhEngine.StartSimulation 1 / 29
End Sub

'here we receive Events, thrown by the PhysicsEngine whilst running the simulation.
'All the "Shapes" we have previsously constructed and added to the engine are not
'"real visual shapes"... yet ... chipmunk is "only" applying its "collision-math",
'according to the dimensions, the mass, the friction etc. of these chipmunk-shapes.
'To visualize these shapes, we make use of this Event - and render all the repositioned
'chipmunk-objects according to their current center-coordinates, their current angel etc.
Private Sub PhEngine_RenderUpdatedScene(ByVal dT As Double, ByVal FPS As Double)
Dim CC As cCairoContext
Static FPSRefreshCounter As Long
  
  Set CC = ucPhysicsCanvas1.CC
  
  FPSRefreshCounter = (FPSRefreshCounter + 1) Mod 20 '<- do'nt stress the refresh in our form-caption too much
  If FPSRefreshCounter = 0 Then
    Caption = "chipmunk-physics, rendered per cairo... FPS (" & _
    IIf(ucPhysicsCanvas1.DXMode, "DX-Mode", "Surface-Mode") & "): " & FPS
  End If
  
  If chkVisualize.Value = 0 Then Exit Sub 'just to be able, to check the FPS' chipmunk is able to achieve "on its own"

  'Ok, after these few preparations above, now the drawing...
  
  'as always, we fill the background first ...in a real game one could of course also use a Surface-Bitmap as the source...
  CC.SetSourceColor vbWhite '...instead of the plain white here...
  CC.Paint
  
  'now we draw our 4 preconstructed chipmunk-shapes (the first two static ones, which will not move)
  OuterBorders.Draw CC
  Ramp.Draw CC
  
  Fluid.Draw CC
  
  Ball.Draw CC

  'this last visualized shape is constructed dynamically in the Mouse-Move-Event - look at the end of this code-module
  If Not MouseShape Is Nothing Then
    CC.PolygonPtr MouseShape.ptVerts, MouseShape.NumVerts, True
      CC.SetSourceColor vbRed
    CC.Stroke
  End If
  
  ucPhysicsCanvas1.Refresh chkStretch.Value
End Sub

Private Sub chkStretch_Click()
  Form_Resize
End Sub

Private Sub chkDirectXMode_Click()
  ucPhysicsCanvas1.DXMode = chkDirectXMode.Value
End Sub

Private Sub Form_Resize() 'here we ensure a correctly stretched and moved usercontrol, whilst keeping the aspectratio conform to our 800x600-Space
Dim AspectRatio As Double, SrcDX&, SrcDY&
Dim DstX&, DstY&, DstDX&, DstDY&
  
  SrcDX = ucPhysicsCanvas1.Srf.Width 'the *Surface*-Width (and Height) is used as SrcDX/SrcDY (not the Dimensions of the hosting ucCanvas, so don't overlook that)
  SrcDY = ucPhysicsCanvas1.Srf.Height
  
  DstX = 0
  DstY = picTopBar.Height  'leave out the "Settings-Area" at the top of the form
  DstDX = Me.ScaleWidth - DstX
  DstDY = Me.ScaleHeight - DstY
  
  
  AspectRatio = SrcDX / SrcDY
  If DstDY * AspectRatio > DstDX Then
    DstY = DstY + ((DstDY - DstDX / AspectRatio) / 2)
    DstDY = DstDX / AspectRatio
  ElseIf DstDX / AspectRatio > DstDY Then
    DstX = DstX + ((DstDX - DstDY * AspectRatio) / 2)
    DstDX = DstDY * AspectRatio
  End If
  
  If DstDX < 1 Then DstDX = 1
  If DstDY < 1 Then DstDY = 1

  If chkStretch.Value Then
    ucPhysicsCanvas1.Move DstX, DstY, DstDX, DstDY
  Else
    ucPhysicsCanvas1.Move DstX + (DstDX - SrcDX) / 2, DstY + (DstDY - SrcDY) / 2, SrcDX, SrcDY
  End If
End Sub

'finally the demonstration of a (somewhat simple) Mouse-interaction, just to show that these Events work, even when scaled
'(the ucCanvas already delivers correctly translated MouseCoords, which match with the chipmunk-space (the 800x600 Bottom-Up-Area)
Private Sub ucPhysicsCanvas1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
  'just a simple "remove-recreate-sequence" (since such operations on the "Physics-Space"
  'are not that costly and CPU-intensive as one may think)
  PhEngine.Space.RemoveStaticShape MouseShape
    PhEngine.MouseBody.BeamTo X, Y
    Set MouseShape = PhEngine.MouseBody.CreateBoxShape(10, 10)
  PhEngine.Space.AddStaticShape MouseShape, 0.1, 0.95
End Sub
